USE [{DBName}]

BEGIN TRANSACTION
SET QUOTED_IDENTIFIER ON
SET ARITHABORT ON
SET NUMERIC_ROUNDABORT OFF
SET CONCAT_NULL_YIELDS_NULL ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
COMMIT

BEGIN TRANSACTION

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'{DBOwner}qi_GoodsRatings') AND type in (N'U'))
BEGIN
	CREATE TABLE {DBOwner}qi_GoodsRatings
	(
		LoginIC bigint NOT NULL,
		LoginU int NOT NULL,
		GoodsIC bigint NOT NULL,
		GoodsU int NOT NULL,
		RatingValue int NOT NULL,
		RatingDate datetime NOT NULL
	)  ON [PRIMARY]

	ALTER TABLE {DBOwner}qi_Goods ADD
		AverageRating numeric(20, 8) NOT NULL CONSTRAINT DF_qi_Goods_AverageRating DEFAULT 0,
		RatingsCount int NOT NULL CONSTRAINT DF_qi_Goods_RatingsCount DEFAULT 0

	CREATE NONCLUSTERED INDEX [ix_GoodsRatings_GoodsICU_RatingValue] ON {DBOwner}[qi_GoodsRatings]
	(
		[GoodsIC] ASC,
		[GoodsU] ASC,
		[RatingValue] ASC
	)WITH (SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF) ON [PRIMARY]

END

GO
COMMIT